/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file exchangedb/pg_lookup_aml_file_number.c
 * @brief Implementation of the lookup_aml_file_number function for Postgres
 * @author Christian Grothoff
 */
#include "taler/platform.h"
#include "taler/taler_error_codes.h"
#include "taler/taler_dbevents.h"
#include "taler/taler_pq_lib.h"
#include "pg_lookup_aml_file_number.h"
#include "pg_helper.h"


enum GNUNET_DB_QueryStatus
TEH_PG_lookup_aml_file_number (
  void *cls,
  const struct TALER_NormalizedPaytoHashP *h_payto,
  uint64_t *kyc_target_row,
  bool *is_wallet)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_auto_from_type (h_payto),
    GNUNET_PQ_query_param_end
  };
  struct GNUNET_PQ_ResultSpec rs[] = {
    GNUNET_PQ_result_spec_uint64 (
      "kyc_target_serial_id",
      kyc_target_row),
    GNUNET_PQ_result_spec_bool (
      "is_wallet",
      is_wallet),
    GNUNET_PQ_result_spec_end
  };

  PREPARE (pg,
           "lookup_aml_file_number",
           "SELECT "
           " kyc_target_serial_id"
           ",is_wallet"
           " FROM kyc_targets"
           " WHERE h_normalized_payto=$1");
  return GNUNET_PQ_eval_prepared_singleton_select (
    pg->conn,
    "lookup_aml_file_number",
    params,
    rs);
}
